### **Day 11: Functions**
Functions are essential building blocks in Python that encapsulate a set of instructions.

- **Function Basics:**
  - Functions are reusable blocks of code that perform a specific task.
  - You can define your own functions in Python.
- **Function Definition and Calling:**
  - Define functions using the `def` keyword, and call them with arguments.
  - Example:

    ```python
    def greet(name):
        print(f"Hello, {name}!")

    greet("Alice")  # Call the greet function with the argument "Alice."
    ```

- **Function Parameters:**
  - Functions can accept parameters (inputs) to perform actions on.
  - Parameters are defined within parentheses in the function definition.
- **Function Invocation:**
  - When a function is called, it executes the code within its block and may return a result.

### **Day 12: Function Parameters and Return Values**
Functions can take parameters (inputs) and return values (outputs).

- **Parameters:**
  - Parameters allow you to pass data into a function.
  - Functions can accept multiple parameters.
  - Example:

    ```python
    def add(x, y):
        result = x + y
        return result

    sum_result = add(3, 5)
    print(sum_result)  # Prints the result of the add function, which is 8.
    ```

- **Return Values:**
  - The `return` statement is used to send a result back from a function.
  - Functions can return values of various data types.

### **Day 13: Built-in Modules**
Python provides built-in modules that offer additional functionality.

- **Importing Modules:**
  - You can use the `import` statement to access built-in modules.
  - Modules extend Python's capabilities for various purposes.
  - Example:

    ```python
    import math

    sqrt_result = math.sqrt(25)  # Calculate the square root of 25.
    print(sqrt_result)  # Prints the result, which is 5.0.
    ```

- **Common Built-in Modules:**
  - Python has a wide range of built-in modules, including `math`, `random`, `datetime`, and `os`, among others.
  - These modules provide functions and classes to solve common programming problems.

### **Day 14: Creating Your Own Modules**
You can create your own Python modules to organize and reuse your code.

- **Module Basics:**
  - A module is a Python file containing functions, variables, and classes.
  - It allows you to organize and encapsulate related code.
- **Creating a Custom Module:**
  - You can create your own modules by defining functions and variables in a Python file.
  - Example:

    ```python
    # my_module.py
    def greet(name):
        print(f"Hello, {name}!")

    # wifi-app.py
    import my_module

    my_module.greet("Bob")  # Call the greet function from the custom module.
    ```

- **Module Reusability:**
  - Modules promote code reusability and maintainability.
  - You can use modules across multiple Python scripts to share functionality.

Understanding functions and modules is essential for writing organized, reusable, and efficient code in Python. By mastering these concepts, you can efficiently structure your programs and make them more maintainable. Practice with these examples to become proficient in using functions and modules in your Python projects.